/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.trowels;

import com.matyrobbrt.trowels.TrowelPlaceContext;
import com.matyrobbrt.trowels.upgrade.TrowelUpgrade;
import com.matyrobbrt.trowels.util.DelegatedCollection;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TrowelItem
extends Item {
    private final IntSupplier durabilityAmount;
    private final BooleanSupplier consumesDurability;

    public TrowelItem(Item.Properties properties, IntSupplier durabilityAmount, BooleanSupplier consumesDurability) {
        super(properties);
        this.durabilityAmount = durabilityAmount;
        this.consumesDurability = consumesDurability;
    }

    public boolean m_8096_(BlockState state) {
        return this.canDestroyPlacedBlock();
    }

    public boolean canDestroyPlacedBlock() {
        return true;
    }

    public boolean acceptsUpgrades() {
        return true;
    }

    public boolean acceptsUpgrade(ItemStack stack, TrowelUpgrade upgrade) {
        return this.acceptsUpgrades();
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return this.canDestroyPlacedBlock();
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        stack.m_41622_(1, entity, p -> p.m_21190_(entity.m_7655_()));
        stack.m_41784_().m_128437_("PlacedBlockPos", 10).remove((Object)TrowelItem.serializePos(pos, level));
        return false;
    }

    static void onDestroySpeed(PlayerEvent.BreakSpeed event) {
        TrowelItem item;
        ItemStack useItem = event.getEntity().m_21120_(event.getEntity().m_7655_());
        Item item2 = useItem.m_41720_();
        if (item2 instanceof TrowelItem && (item = (TrowelItem)item2).canDestroyPlacedBlock()) {
            if (!event.getEntity().m_6144_()) {
                event.setCanceled(true);
                return;
            }
            event.getPosition().ifPresentOrElse(pos -> {
                CompoundTag nbtPos;
                ListTag clickedPoses = useItem.m_41784_().m_128437_("PlacedBlockPos", 10);
                if (clickedPoses.contains((Object)(nbtPos = TrowelItem.serializePos(pos, event.getEntity().m_9236_())))) {
                    event.setNewSpeed(18.0f);
                } else {
                    event.setCanceled(true);
                }
            }, () -> event.setCanceled(true));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        CompoundTag posSer;
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        InteractionHand hand = context.m_43724_();
        IntArrayList targets = new IntArrayList();
        for (int i = 0; i < Inventory.m_36059_(); ++i) {
            if (!TrowelItem.isValidTarget(player.m_150109_().m_8020_(i))) continue;
            targets.add(i);
        }
        if (targets.isEmpty()) {
            return InteractionResult.PASS;
        }
        ItemStack trowel = player.m_21120_(hand);
        CompoundTag tag = trowel.m_41784_();
        Random rand = new Random(tag.m_128454_("Seed"));
        tag.m_128356_("Seed", rand.nextLong());
        int roll = targets.getInt(rand.nextInt(targets.size()));
        ItemStack target = player.m_150109_().m_8020_(roll);
        int count = target.m_41613_();
        InteractionResult result = this.placeBlock(roll, target, context);
        this.getUpgrades(trowel).forEach(upgrade -> upgrade.afterPlace(trowel, context, roll, target));
        if (player.m_150110_().f_35937_) {
            target.m_41764_(count);
        }
        if (result.m_19077_() && this.consumesDurability.getAsBoolean()) {
            context.m_43722_().m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        }
        BlockPos placePos = context.m_8083_().m_121945_(context.m_43719_());
        ListTag clickedPoses = tag.m_128437_("PlacedBlockPos", 10);
        if (clickedPoses.size() > 5) {
            clickedPoses.remove(0);
        }
        if (!clickedPoses.contains((Object)(posSer = TrowelItem.serializePos(placePos, context.m_43725_())))) {
            clickedPoses.add((Object)posSer);
        }
        tag.m_128365_("PlacedBlockPos", (Tag)clickedPoses);
        return result;
    }

    public Collection<TrowelUpgrade> getUpgrades(final ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        final ListTag upgradesTag = tag.m_128441_("Upgrades") ? tag.m_128437_("Upgrades", 8) : (ListTag)Util.m_137469_((Object)new ListTag(), it -> tag.m_128365_("Upgrades", (Tag)it));
        EnumSet<TrowelUpgrade> upgrades = EnumSet.noneOf(TrowelUpgrade.class);
        upgradesTag.forEach(it -> upgrades.add(TrowelUpgrade.valueOf(it.m_7916_())));
        return new DelegatedCollection<TrowelUpgrade>(upgrades){

            @Override
            public boolean add(TrowelUpgrade trowelUpgrade) {
                if (!TrowelItem.this.acceptsUpgrade(stack, trowelUpgrade)) {
                    return false;
                }
                boolean flag = super.add(trowelUpgrade);
                if (flag) {
                    upgradesTag.add((Object)StringTag.m_129297_((String)trowelUpgrade.name()));
                }
                return flag;
            }
        };
    }

    private InteractionResult placeBlock(int rolledSlot, ItemStack rolledStack, UseOnContext context) {
        Player player = context.m_43723_();
        ItemStack toRestore = player.m_21120_(context.m_43724_());
        InteractionResult res = rolledStack.m_41661_((UseOnContext)new TrowelPlaceContext(context, rolledStack, rolledSlot));
        player.m_21008_(context.m_43724_(), toRestore);
        return res;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.consumesDurability.getAsBoolean() ? this.durabilityAmount.getAsInt() : 0;
    }

    public boolean m_41465_() {
        return this.consumesDurability.getAsBoolean();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        components.add((Component)Component.m_237115_((String)"desc.trowels.trowel").m_130940_(ChatFormatting.AQUA));
        components.add((Component)Component.m_237115_((String)"desc.trowels.trowel.destroy_recent").m_130940_(ChatFormatting.GOLD));
        Collection<TrowelUpgrade> upgrades = this.getUpgrades(stack);
        if (!upgrades.isEmpty()) {
            components.add((Component)Component.m_237113_((String)" "));
            components.add((Component)Component.m_237115_((String)"tooltip.trowels.upgrades"));
            upgrades.forEach(up -> components.add(up.getName()));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44985_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    private static boolean isValidTarget(ItemStack stack) {
        Item item = stack.m_41720_();
        return !stack.m_41619_() && item instanceof BlockItem;
    }

    private static CompoundTag serializePos(BlockPos pos, Level level) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("x", pos.m_123341_());
        tag.m_128405_("y", pos.m_123342_());
        tag.m_128405_("z", pos.m_123343_());
        tag.m_128359_("dimension", level.m_46472_().m_135782_().toString());
        return tag;
    }
}

